<?php

namespace App\Notifications;

use App\Traits\SmtpSettingsTrait;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;

class AddPaymentNotification extends Notification
{
    use Queueable;
    private $data;
    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct($data)
    {
        $this->data = $data;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        $via = ['database', 'mail'];
        return $via;
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        $url = url('/customer');

        return (new MailMessage)
            ->subject( 'Fitsigma Customer App - Payment Notification')
            ->greeting('Hello '.ucwords($notifiable->name).'!')
            ->line('Your payment for the subscription is recorded successfully by admin.')
            ->action('Login To Dashboard', $url)
            ->line('Thank you for using our application!');
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toDatabase($notifiable)
    {
        return [
            'customer_id' => $notifiable->id,
            'notification_type' => 'Payment Added',
            'title' => 'Payment recorded successfully.'
        ];
    }
}
